#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
import time
from datetime import datetime, timedelta
import com.xhaus.jyson.JysonCodec as json
from bamboo import create_build_record

start_time = time.time()

print "Executing RunPlan.py\n"

if bambooServer is None:
	print "No server provided."
	sys.exit(1)

contentType = 'application/json'
headers = {'accept' : 'application/json'}

def finished(brkey):
	response = request.get('/rest/api/latest/result/' + brkey, contentType=contentType, headers=headers)
	return json.loads(response.response)['finished']

def successful(brkey):
	response = request.get('/rest/api/latest/result/' + brkey, contentType=contentType, headers=headers)
	return json.loads(response.response)['successful']

def getKeyStatesAndTimes(brkey):
	response = request.get('/rest/api/latest/result/' + brkey, contentType=contentType, headers=headers)
	jsonData = json.loads(response.response)
	return (jsonData['planResultKey']['key'], jsonData['buildState'], jsonData['state'], jsonData['prettyBuildStartedTime'], jsonData['prettyBuildCompletedTime'])

def format_duration(time_delta):
	"""
    Formats a timedelta object into a string representation of the duration.
    """
	days = time_delta.days
	hours, remainder = divmod(time_delta.seconds, 3600)
	minutes, seconds = divmod(remainder, 60)
	return "%sd %sh %sm %ss" % (days,hours,minutes,seconds)

credentials = CredentialsFallback(bambooServer, username, password).getCredentials()
request = HttpRequest(bambooServer, credentials['username'], credentials['password'])
response = request.post('/rest/api/latest/queue/' + projPlanKey, '{}', contentType=contentType, headers=headers)
result = json.loads(response.response)
buildNumber = result['buildNumber']
print 'Build number is ' + str(buildNumber) + '\n'
brkey = result['buildResultKey']

while (not finished(brkey)):
	time.sleep(5)

(planResultKey, buildState, state, prettyBuildStartedTime, prettyBuildCompletedTime) = getKeyStatesAndTimes(brkey)

print "Build job started at " + prettyBuildStartedTime + "\n"
build_url="%s/rest/api/latest/result/%s" % (bambooServer['url'],brkey)

end_time=time.time()
start_date = datetime.utcfromtimestamp(start_time)
end_date = datetime.utcfromtimestamp(end_time)
str_duration = format_duration(timedelta(milliseconds=end_time-start_time))

if successful(brkey):
	print("Build job completed successfully at " + prettyBuildCompletedTime + "\n")
	create_build_record(task_reporting_api=taskReportingApi, task=task, server=bambooServer, project=projPlanKey, build_url=build_url, build_id=brkey, build_status="Build Successful", start_date=start_date, end_date=end_date, duration=str_duration)
else:
	print "Build job failed at " + prettyBuildCompletedTime + "\n"
	create_build_record(task_reporting_api=taskReportingApi, task=task, server=bambooServer, project=projPlanKey, build_url=build_url, build_id=brkey, build_status="Build Failed", start_date=start_date, end_date=end_date, duration=str_duration)
if failTask:
		raise Exception("Build job failed at " + prettyBuildCompletedTime + "\n")

