/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin;

import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.plugin.ExternalVariableResolutionFailedException;
import com.xebialabs.deployit.plugin.ProxyProtocol;
import com.xebialabs.deployit.plugin.SecretManagerHelper;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.ExternalVariableServer;
import com.xebialabs.xlrelease.domain.variables.ExternalVariableValue;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Metadata(label="AWS Secrets Manager")
public class SecretsManager
extends ExternalVariableServer {
    @Property(description="Script Location", required=false, hidden=true, defaultValue="aws/check_connection.py")
    private String scriptLocation;
    @Property(label="AWS Region", description="The AWS Region", required=true)
    private String region;
    @Property(label="Access Key", description="The access key to connect to AWS.", required=true)
    private String accessKey;
    @Property(label="Access Secret", description="The access secret key to connect to AWS", password=true)
    private String accessSecret;
    @Property(label="Session Token", description="The session token  to connect to AWS", required=false, password=true)
    private String sessionToken;
    @Property(label="Proxy Protocol", required=true, defaultValue="http", description="Scheme/protocol of the proxy server to use while connecting to AWS")
    private ProxyProtocol proxyProtocol;
    @Property(label="Proxy Host", description="Hostname of the proxy server to use while connecting to AWS", required=false)
    private String proxyHost;
    @Property(label="Proxy Port", description="Port number of the proxy server to use while connecting to AWS", required=false, defaultValue="0")
    private Integer proxyPort = 0;
    @Property(label="Proxy User", description="Proxy Server Username", required=false)
    private String proxyUser;
    @Property(label="Proxy Password", description="Proxy Server Password", required=false)
    private String proxyPassword;
    @Property(description="Hidden as sdk is used", required=false, hidden=true, defaultValue="locahost")
    private String url;
    @Property(description="Hidden as sdk is used", password=true, required=false, hidden=true, category="Authentication")
    private String token;

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getAccesskey() {
        return this.accessKey;
    }

    public void setAccesskey(String accesskey) {
        this.accessKey = accesskey;
    }

    public String getAccessSecret() {
        return this.accessSecret;
    }

    public void setAccessSecret(String accessSecret) {
        this.accessSecret = accessSecret;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public ProxyProtocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public void setProxyProtocol(ProxyProtocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public Map<String, String> lookup(List<PasswordStringVariable> variables) {
        PasswordEncrypter passwordEncrypter = PasswordEncrypter.getInstance();
        String awsAccessSecret = this.accessSecret;
        if (passwordEncrypter.isEncrypted(this.accessSecret)) {
            awsAccessSecret = passwordEncrypter.decrypt(awsAccessSecret);
        }
        SecretManagerHelper helper = new SecretManagerHelper(this.accessKey, awsAccessSecret, this.sessionToken, this.region, this.proxyProtocol, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword);
        try {
            helper.checkConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String secretName = null;
        String secretKey = null;
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        try {
            for (PasswordStringVariable var : variables) {
                ExternalVariableValue externalVariableValue = var.getExternalVariableValue();
                secretName = externalVariableValue.getPath();
                Map<String, String> secretEntries = helper.getSecretEntries(secretName);
                secretKey = externalVariableValue.getExternalKey();
                if (secretKey == null || secretKey.equals("")) {
                    secretKey = secretName;
                }
                String retrievedValue = this.assertNotNull(secretEntries.get(secretKey), "Key not found.", new Object[0]);
                lookupMap.put(var.getKey(), retrievedValue.toString());
            }
        }
        catch (ExternalVariableResolutionFailedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ExternalVariableResolutionFailedException("Unable to lookup secret '%s' and key '%s' in AWS SecretsManager; reason: %s", secretName, secretKey == null ? "" : secretKey, t.getMessage());
        }
        return lookupMap;
    }

    private <T> T assertNotNull(T object, String message, Object ... args) {
        if (object != null) {
            return object;
        }
        throw new DeployitException(message, args);
    }
}

