/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin;

import com.google.gson.Gson;
import com.xebialabs.deployit.plugin.ProxyProtocol;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.DeleteSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.DeleteSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretsResponse;
import software.amazon.awssdk.services.secretsmanager.model.UpdateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.UpdateSecretResponse;

public class SecretManagerHelper {
    private String accessKey;
    private String secretKey;
    private String sessionToken;
    private String region;
    private String proxyProtocol;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private PasswordEncrypter passwordEncrypter;
    Logger logger = Logger.getLogger(this.getClass().getName());

    public SecretManagerHelper(String accessKey, String secretKey, String sessionToken, String region, ProxyProtocol proxyProtocol, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.sessionToken = sessionToken;
        this.region = region;
        this.proxyProtocol = proxyProtocol.name();
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
        this.passwordEncrypter = PasswordEncrypter.getInstance();
        if (this.passwordEncrypter.isEncrypted(secretKey)) {
            this.secretKey = this.passwordEncrypter.decrypt(secretKey);
        }
        if (this.passwordEncrypter.isEncrypted(sessionToken)) {
            this.sessionToken = this.passwordEncrypter.decrypt(sessionToken);
        }
    }

    public SecretsManagerClient createClient() throws Exception {
        Object credentialsProvider = null;
        if (this.sessionToken != null) {
            if (this.accessKey != null && this.secretKey != null) {
                credentialsProvider = new AwsCredentialsProvider(){

                    public AwsCredentials resolveCredentials() {
                        return AwsSessionCredentials.create((String)SecretManagerHelper.this.accessKey, (String)SecretManagerHelper.this.secretKey, (String)SecretManagerHelper.this.sessionToken);
                    }
                };
            }
        } else if (this.accessKey != null && this.secretKey != null) {
            credentialsProvider = new AwsCredentialsProvider(){

                public AwsCredentials resolveCredentials() {
                    return AwsBasicCredentials.create((String)SecretManagerHelper.this.accessKey, (String)SecretManagerHelper.this.secretKey);
                }
            };
        }
        SecretsManagerClientBuilder secretsClientBuilder = null;
        secretsClientBuilder = credentialsProvider != null ? (SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(Region.of((String)this.region))).credentialsProvider((AwsCredentialsProvider)credentialsProvider) : (SecretsManagerClientBuilder)SecretsManagerClient.builder().region(Region.of((String)this.region));
        if (this.proxyHost != null && !this.proxyHost.equals("")) {
            ProxyConfiguration.Builder proxyConfig = ProxyConfiguration.builder().endpoint(new URI(String.format("%s://%s:%d", this.proxyProtocol, this.proxyHost, this.proxyPort)));
            if (this.proxyUser != null && !this.proxyUser.equals("")) {
                proxyConfig.username(this.proxyUser);
            }
            if (this.proxyPassword != null && !this.proxyPassword.equals("")) {
                proxyConfig.password(this.proxyPassword);
            }
            ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            return (SecretsManagerClient)((SecretsManagerClientBuilder)secretsClientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder)).build();
        }
        return (SecretsManagerClient)secretsClientBuilder.build();
    }

    public boolean checkConnection() throws Exception {
        ListSecretsResponse response = this.createClient().listSecrets();
        if (response.sdkHttpResponse().isSuccessful()) {
            return true;
        }
        throw new Exception("Authentication failed" + response.sdkHttpResponse().statusText());
    }

    public String getSecretString(String secretName) throws Exception {
        GetSecretValueResponse response = this.createClient().getSecretValue((GetSecretValueRequest)((Object)GetSecretValueRequest.builder().secretId(secretName).build()));
        if (!response.sdkHttpResponse().isSuccessful()) {
            throw new Exception("Get Secret Failed:" + response.sdkHttpResponse().statusCode() + ":" + response.sdkHttpResponse().statusText());
        }
        String secretString = response.secretString();
        return secretString;
    }

    public Map<String, String> getSecretEntries(String secretName) throws Exception {
        HashMap secretMap;
        String secretString = this.getSecretString(secretName);
        if (!secretString.startsWith("{")) {
            secretMap = new HashMap();
            secretMap.put(secretName, secretString);
        } else {
            secretMap = (HashMap)new Gson().fromJson(secretString, HashMap.class);
        }
        return secretMap;
    }

    public String getSecret(String secretName, String secretKey) throws Exception {
        String secretString = this.getSecretString(secretName);
        if (secretKey != null && secretString.startsWith("{")) {
            HashMap secretEntries = (HashMap)new Gson().fromJson(secretString, HashMap.class);
            if (secretEntries.containsKey(secretKey)) {
                return (String)secretEntries.get(secretKey);
            }
            throw new Exception("No secret entry found for the given key");
        }
        return secretString;
    }

    public void createSecret(String secretName, String secretString) throws Exception {
        CreateSecretRequest request = (CreateSecretRequest)((Object)CreateSecretRequest.builder().name(secretName).secretString(secretString).build());
        CreateSecretResponse response = this.createClient().createSecret(request);
        if (!response.sdkHttpResponse().isSuccessful()) {
            throw new Exception("Create Secret Failed:" + response.sdkHttpResponse().statusCode() + ":" + response.sdkHttpResponse().statusText());
        }
        this.logger.info("Secret created successfully");
    }

    public void updateSecret(String secretName, String secretString) throws Exception {
        UpdateSecretRequest request = (UpdateSecretRequest)((Object)UpdateSecretRequest.builder().secretId(secretName).secretString(secretString).build());
        UpdateSecretResponse response = this.createClient().updateSecret(request);
        if (!response.sdkHttpResponse().isSuccessful()) {
            throw new Exception("Create Secret Failed:" + response.sdkHttpResponse().statusCode() + ":" + response.sdkHttpResponse().statusText());
        }
        this.logger.info("Secret created successfully");
    }

    public void deleteSecret(String secretName) throws Exception {
        DeleteSecretRequest request = (DeleteSecretRequest)((Object)DeleteSecretRequest.builder().secretId(secretName).build());
        DeleteSecretResponse response = this.createClient().deleteSecret(request);
        if (!response.sdkHttpResponse().isSuccessful()) {
            throw new Exception("Delete Secret Failed:" + response.sdkHttpResponse().statusCode() + ":" + response.sdkHttpResponse().statusText());
        }
        this.logger.info("Secret deleted successfully");
    }
}

