package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import org.springframework.stereotype.Component

@Component
@EventListener
class GlobalVariableAuditHandler extends AuditLogger[GlobalVariableEvent] {

  @Subscribe
  def onGlobalVariableEvent(event: GlobalVariableEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case GlobalVariableCreatedEvent(v, _) => AuditParams(repository, Messages.created(v), v)
    case GlobalVariableUpdatedEvent(_, u, _) => AuditParams(repository, Messages.updated(u), u)
    case GlobalVariableDeletedEvent(v, _) => AuditParams(repository, Messages.deleted(v), v)
  }
}

@Component
@EventListener
class FolderVariableAuditHandler extends AuditLogger[FolderVariableEvent] {

  @Subscribe
  def onFolderVariableEvent(event: FolderVariableEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case FolderVariableCreatedEvent(v, _) => AuditParams(repository, Messages.created(v), v)
    case FolderVariableUpdatedEvent(_, u, _) => AuditParams(repository, Messages.updated(u), u)
    case FolderVariableDeletedEvent(v, _) => AuditParams(repository, Messages.deleted(v), v)
  }
}
