package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import org.springframework.stereotype.Component

@Component
@EventListener
class UserProfileAuditHandler extends AuditLogger[UserProfileEvent] {

  @Subscribe
  def onUserProfileEvent(event: UserProfileEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case UserProfileCreatedEvent(profile) => AuditParams(repository, Messages.created(profile), profile)
    case UserProfileUpdatedEvent(profile) => AuditParams(repository, Messages.updated(profile), profile)
    case UserProfileDeletedEvent(profile) => AuditParams(repository, Messages.deleted(profile), profile)
  }
}
