package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import org.springframework.stereotype.Component

@Component
@EventListener
class CategoryAuditHandler extends AuditLogger[CategoryEvent] {

  @Subscribe
  def onCategoryEvent(event: CategoryEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case CategoryCreatedEvent(category) => AuditParams(repository, Messages.created(category), category)
    case CategoryUpdatedEvent(_, category) => AuditParams(repository, Messages.updated(category), category)
    case CategoryDeletedEvent(category) => AuditParams(repository, Messages.deleted(category), category)
  }
}
