package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import org.springframework.stereotype.Component

@Component
@EventListener
class TenantLimitAuditHandler extends AuditLogger[TenantLimitEvent] {

  @Subscribe
  def onTenantLimitEvent(event: TenantLimitEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case event: TenantLimitEvent => event match {
      case TenantLimitCreatedEvent(tenantLimit) => AuditParams(repository, Messages.created(tenantLimit), tenantLimit)
      case TenantLimitUpdatedEvent(_, updated) => AuditParams(repository, Messages.updated(updated), updated)
      case TenantLimitDeletedEvent(tenantLimit) => AuditParams(repository, Messages.deleted(tenantLimit), tenantLimit)
    }
  }
}
