package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import org.springframework.stereotype.Component

@Component
@EventListener
class TenantAuditHandler extends AuditLogger[TenantEvent] {

  @Subscribe
  def onTenantEvent(event: TenantEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case event: TenantEvent => event match {
      case TenantCreatedEvent(tenant) =>
        AuditParams(repository, s"Created tenant: $tenant")
      case TenantUpdatedEvent(_, updated) =>
        AuditParams(repository, s"Updated tenant: $updated")
      case TenantDeletedEvent(tenant) =>
        AuditParams(repository, s"Deleted tenant: $tenant")
      case event: TenantLinkUpdatedEvent =>
        AuditParams(repository, s"Updated tenantLinkUpdated: $event")
    }
  }
}
