package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.system
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import org.springframework.stereotype.Component

@Component
@EventListener
class DatacenterAuditHandler extends AuditLogger[DatacenterEvent] {

  @Subscribe
  def onDatacenterEvent(event: DatacenterEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case DatacenterCreatedEvent(datacenter, targetState) =>
      AuditParams(system, s"Created datacenter '$datacenter' with target state '$targetState'")
    case DatacenterDeletedEvent(datacenter) =>
      AuditParams(system, s"Deleted datacenter '$datacenter'")
    case DatacenterUpdatedEvent(datacenter, previousTargetState, newTargetState) =>
      AuditParams(system, s"Updated datacenter '$datacenter' from target state '$previousTargetState' to '$newTargetState'")
  }
}
