package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.domain.events.{ClusterManagementEvent, ClusterNodeStartEvent, ClusterNodeStopEvent, XLReleaseEvent}
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import org.springframework.stereotype.Component

@Component
@EventListener
class ClusterManagementAuditHandler extends AuditLogger[XLReleaseEvent] {

  @Subscribe
  def onClusterManagementEvent(event: XLReleaseEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case event: ClusterManagementEvent =>
      val action = event match {
        case _: ClusterNodeStartEvent => "start"
        case _: ClusterNodeStopEvent  => "stop"
      }
      AuditParams(Components.system, s"Attempting to $action the cluster node")
  }
}
