package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import com.xebialabs.xlrelease.risk.domain.events.RiskProfileUpdated
import org.springframework.stereotype.Component

@Component
@EventListener
class ConfigurationAuditHandler extends AuditLogger[ConfigurationEvent] {

  @Subscribe
  def onConfigurationEvent(event: ConfigurationEvent): Unit = log(event)

  @Subscribe
  def onRiskProfileEvent(event: RiskProfileUpdated): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case ConfigurationCreatedEvent(conf) => AuditParams(repository, Messages.created(conf), conf)
    case ConfigurationUpdatedEvent(conf) => AuditParams(repository, Messages.updated(conf), conf)
    case RiskProfileUpdated(rp) => AuditParams(repository, Messages.updated(rp), rp)
    case ConfigurationDeletedEvent(conf) => AuditParams(repository, Messages.deleted(conf), conf)
    case ConfigurationCopiedEvent(original, id) => AuditParams(repository, Messages.copied(original, id), original)
  }
}
