package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import com.xebialabs.xlrelease.repository.ReleaseRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
@EventListener
class ReleaseAuditHandler @Autowired()(val releaseRepository: ReleaseRepository) extends AuditLogger[ReleaseEvent] {

  @Subscribe
  def onReleaseEvent(event: ReleaseEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case ReleaseCreatedEvent(release, _) => AuditParams(repository, Messages.created(release), release)
    case ReleaseUpdatedEvent(_, updated) => AuditParams(repository, Messages.updated(updated), updated)
    case ReleaseDeletedEvent(deleted) => AuditParams(repository, Messages.deleted(deleted), deleted)
    case ReleaseDuplicatedEvent(duplicated) => AuditParams(repository, Messages.copied(duplicated), duplicated)
    case ReleaseMovedEvent(oldId, newId) =>
      val moved = releaseRepository.findById(newId)
      AuditParams(repository, Messages.moved(moved, oldId), moved)
    case ReleaseUpdatedFromAsCodeEvent(updated, _) => AuditParams(repository, Messages.updated(updated), updated)
  }
}
