package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent
import com.xebialabs.xlrelease.events._
import org.springframework.stereotype.Component

@Component
@EventListener
class ReleaseGroupAuditHandler extends AuditLogger[ReleaseGroupEvent] {

  @Subscribe
  def onReleaseGroupEvent(event: ReleaseGroupEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case ReleaseGroupCreatedEvent(rg) => AuditParams(repository, Messages.created(rg), rg)
    case ReleaseGroupUpdatedEvent(rg) => AuditParams(repository, Messages.updated(rg), rg)
    case ReleaseGroupDeletedEvent(rg) => AuditParams(repository, Messages.deleted(rg), rg)
  }
}
