package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.domain.UserToken
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import org.springframework.stereotype.Component

@Component
@EventListener
class UserTokenAuditHandler extends AuditLogger[UserTokenEvent]{

  @Subscribe
  def onUserTokenEvent(event: UserTokenEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case UserTokenCreatedEvent(userToken) =>
      AuditParams(repository, getLogMessage(userToken, "Created"))
    case UserTokenDeletedEvent(userToken) =>
      AuditParams(repository, getLogMessage(userToken, "Deleted"))
    case UserTokensDeletedEvent(tokenUser) =>
      AuditParams(repository, s"Deleted all the personal access tokens for '$tokenUser'")

  }

  private def getLogMessage(userToken: UserToken, operation: String): String = {
    s"$operation a personal access token for '${userToken.username}' with note '${userToken.tokenNote}'"
  }
}
