package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@EventListener
class TeamsAndPermissionsAuditHandler extends AuditLogger[TeamEvent] {

  @Subscribe
  def onTeamEvent(event: TeamEvent): Unit = log(event)

  @Subscribe
  def onPermissionsEvent(event: PermissionsEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    //TeamsEvents:
    case TeamCreatedEvent(_, team) => AuditParams(repository, Messages.created(team), team)
    case TeamDeletedEvent(_, team) => AuditParams(repository, Messages.deleted(team), team)
    case TeamsMergedEvent(folderTitle, templateId) => AuditParams(repository,
      s"Teams of xlrelease.Template[$templateId] merged into Teams of xlrelease.Folder[$folderTitle]")
    case TeamsRemovedInTemplateEvent(folderTitle, templateId) => AuditParams(repository,
      s"Teams of xlrelease.Template[$templateId] are removed when it's moved to xlrelease.Folder[$folderTitle]")
    case TeamUpdatedEvent(_, _, updated) => AuditParams(repository, Messages.updated(updated), updated)
    //PermissionsEvents:
    case PermissionsUpdatedEvent(teams) => AuditParams(repository, Messages.updated(teams.asScala.toSeq), teams.asScala.toSeq)
  }

}
