package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import com.xebialabs.xlrelease.reports.job.events.{ReportJobAbortedEvent, ReportJobDeletedEvent, ReportJobEvent, ReportJobSubmittedEvent}
import org.springframework.stereotype.Component

@Component
@EventListener
class ReportJobAuditHandler extends AuditLogger[ReportJobEvent] {

  @Subscribe
  def onReportJobEvent(event: ReportJobEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    //keep this as updated since actual data is not deleted, but just updated
    case ReportJobDeletedEvent(reportJob) => AuditParams(repository, Messages.updated(reportJob), reportJob)
    case ReportJobAbortedEvent(reportJob) => AuditParams(repository, Messages.updated(reportJob), reportJob)
    case ReportJobSubmittedEvent(reportJob) => AuditParams(repository, Messages.created(reportJob), reportJob)
  }
}
