package com.xebialabs.xlrelease.audit

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem

object AuditParams {
  def apply(component: String, message: String, ci: ConfigurationItem): AuditParams = {
    new AuditParams(component, message, Seq(ci))
  }

  def apply(component: String, message: String): AuditParams = {
    new AuditParams(component, message, Seq())
  }

  def ignored: AuditParams = AuditParams(null, "")
}

case class AuditParams(component: String, message: String, cis: Seq[ConfigurationItem])
