package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import org.springframework.stereotype.Component

@Component
@EventListener
class FacetAuditHandler extends AuditLogger[FacetEvent] {

  @Subscribe
  def onFacetEvent(event: FacetEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case FacetCreatedEvent(facet) => AuditParams(repository, Messages.created(facet), facet)
    case FacetUpdatedEvent(_, facet) => AuditParams(repository, Messages.updated(facet), facet)
    case FacetDeletedEvent(facet) => AuditParams(repository, Messages.deleted(facet), facet)
  }
}
