package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent
import com.xebialabs.xlrelease.environments.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import org.springframework.stereotype.Component

@Component
@EventListener
class EnvironmentAuditHandler extends AuditLogger[EnvironmentEvent] {

  @Subscribe
  def onEnvironmentEvent(event: EnvironmentEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case EnvironmentCreatedEvent(env) => AuditParams(repository, Messages.created(env), env)
    case EnvironmentUpdatedEvent(env) => AuditParams(repository, Messages.updated(env), env)
    case EnvironmentDeletedEvent(env) => AuditParams(repository, Messages.deleted(env), env)
  }
}

@Component
@EventListener
class ApplicationAuditHandler extends AuditLogger[ApplicationEvent] {

  @Subscribe
  def onApplicationEvent(event: ApplicationEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case ApplicationCreatedEvent(app) => AuditParams(repository, Messages.created(app), app)
    case ApplicationUpdatedEvent(app) => AuditParams(repository, Messages.updated(app), app)
    case ApplicationDeletedEvent(app) => AuditParams(repository, Messages.deleted(app), app)
  }
}

@Component
@EventListener
class EnvironmentReservationAuditHandler extends AuditLogger[EnvironmentReservationEvent] {

  @Subscribe
  def onEnvironmentReservationEvent(event: EnvironmentReservationEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case EnvironmentReservationCreatedEvent(er) => AuditParams(repository, Messages.created(er), er)
    case EnvironmentReservationUpdatedEvent(er) => AuditParams(repository, Messages.updated(er), er)
    case EnvironmentReservationDeletedEvent(er) => AuditParams(repository, Messages.deleted(er), er)
  }
}
