package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent
import com.xebialabs.xlrelease.events._
import com.xebialabs.xlrelease.plugins.dashboard.events.{DashboardCreatedEvent, DashboardDeletedEvent, DashboardEvent, DashboardUpdatedEvent}
import org.springframework.stereotype.Component

@Component
@EventListener
class DashboardAuditHandler extends AuditLogger[DashboardEvent] {

  @Subscribe
  def onDashboardEvent(event: DashboardEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case DashboardCreatedEvent(d) => AuditParams(repository, Messages.created(d), d)
    case DashboardUpdatedEvent(d) => AuditParams(repository, Messages.updated(d), d)
    case DashboardDeletedEvent(d) => AuditParams(repository, Messages.deleted(d), d)
  }
}
