package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.audit.Messages.created
import com.xebialabs.xlrelease.domain.ActivityLogEntry
import com.xebialabs.xlrelease.domain.ReleaseActivity._
import com.xebialabs.xlrelease.domain.events.{ActivityLogEvent, XLReleaseEvent}
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import org.springframework.stereotype.Component

@Component
@EventListener
class ActivityLogAuditHandler extends AuditLogger[ActivityLogEvent] {

  private def teamEventActivityTypes = List(TEAM_CREATED.name(), TEAM_UPDATED.name(), TEAM_DELETED.name(),
    FOLDER_TEAM_MERGED.name(), REMOVE_TEMPLATE_TEAMS.name(), PERMISSIONS_UPDATED.name())

  @Subscribe
  def onActivityLogEvent(event: ActivityLogEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case ev@ActivityLogEvent(_, id, activityType, msg, eventTime, targetType, targetId) if !teamEventActivityTypes.contains(activityType) =>
      val ci = new ActivityLogEntry(eventTime, activityType, ev.username, msg, targetType, targetId)
      ci.setId(id)
      AuditParams(repository, created(ci), ci)
  }
}
