package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.delivery.events._
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent
import com.xebialabs.xlrelease.events._
import org.springframework.stereotype.Component

@Component
@EventListener
class DeliveryAuditHandler extends AuditLogger[ReleaseGroupEvent] {

  @Subscribe
  def onDeliveryEvent(event: DeliveryEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case DeliveryCreatedEvent(delivery) => AuditParams(repository, Messages.created(delivery), delivery)
    case DeliveryUpdatedEvent(delivery) => AuditParams(repository, Messages.updated(delivery), delivery)
    case DeliveryDeletedEvent(delivery) => AuditParams(repository, Messages.deleted(delivery), delivery)
    case DeliveryCreatedFromAsCodeEvent(delivery, _) => AuditParams(repository, Messages.created(delivery), delivery)
    case DeliveryUpdatedFromAsCodeEvent(delivery, _) => AuditParams(repository, Messages.updated(delivery), delivery)
  }
}
