package com.xebialabs.xlrelease.audit

import com.xebialabs.xlrelease.audit.Components.repository
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import org.springframework.stereotype.Component

@Component
@EventListener
class FolderAuditHandler extends AuditLogger[FolderEvent] {

  @Subscribe
  def onFolderEvent(event: FolderEvent): Unit = log(event)

  override def audit: PartialFunction[XLReleaseEvent, AuditParams] = {
    case FolderCreatedEvent(folder) => AuditParams(repository, Messages.created(folder), folder)
    case FolderDeletedEvent(folder) => AuditParams(repository, Messages.deleted(folder), folder)
    case FolderMovedEvent(folder, oldParentId, _) => AuditParams(repository, Messages.moved(folder, oldParentId), folder)
    case FolderRenamedEvent(folder, newName) => AuditParams(repository, Messages.renamed(folder, newName), folder)
  }
}
