#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from argocd.argocd_rest_client import RestClient

def validate_mandatory_field(field, error):
    if not field:
        raise ValueError(error)

validate_mandatory_field(argocdServer, "Missing value for ArgoCD Server")
validate_mandatory_field(appName, "Missing value for App Name")

task.setStatusLine("Deleting Application '%s' " % appName)
response = RestClient(argo_server=argocdServer).deleteApplication(appName, propagationPolicy, appNamespace)
if waitForSuccessfulDel:
    appStatus = RestClient(argo_server=argocdServer).getAppHistory(appName)
    app_status = appStatus["status"]
    if app_status != 404:
        task.schedule("argocd/waitForDeleteApplication.py")
else:
    task.setStatusLine("Application '%s' deleted" % appName)