#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#
import json
from xlrelease.HttpRequest import HttpRequest
from argocd.argocd_rest_client import RestClient

response = RestClient(argo_server=argocdServer).getSyncStatus(appName)
status_obj = response["status"]
currentRetryCount = currentRetryCount + 1

if response["syncFailed"]:
    raise ValueError('Sync failed after rollback %s' % response["message"])
elif status_obj["syncStatus"] != "Synced":
    if currentRetryCount < maxRetries:
        task.setStatusLine("Sync status %s, Retry #%d" % (status_obj["syncStatus"], currentRetryCount))
        task.schedule("argocd/waitForSuccessfulRollback.py", retryWaitTime)
    else:
        raise Exception("Status check retry exhausted.")
else:
    status = status_obj
