#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from argocd.argocd_rest_client import RestClient

def validate_mandatory_field(field, error):
    if not field:
        raise Exception(error)

try:
    validate_mandatory_field(argocdServer, "ArgoCD server ID must be provided")
    validate_mandatory_field(appName, "Missing value for App Name")

    client = RestClient(argo_server=argocdServer)
    response = client.getResourceTree(appName)
    hosts = response['hosts']
    nodes = response['nodes']

    for i in range(len(hosts)):
        hosts[i]['nodes'] = []
        for j in range(len(nodes)):
            if nodes[j]['kind'].lower() == "pod":
                info = nodes[j]['info']
                for k in range(len(info)):
                    if info[k]['name'].lower() == "node" and info[k]['value'] == hosts[i]['name']:
                        hosts[i]['nodes'].append(nodes[j])
                        break;

    data = {}
    data = {"hosts": hosts}
except Exception as e:
    print("Exception occurred: {0} ".format(str(e)))
    data = {'error': [{'msg': str(e)}]}
