#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#
from argocd.argocd_rest_client import RestClient

def validate_mandatory_field(field, error):
    if not field:
        raise ValueError(error)

validate_mandatory_field(argocdServer, "Missing value for ArgoCD Server")
validate_mandatory_field(appName, "Missing value for App Name")

status = RestClient(argo_server=argocdServer).getSyncStatus(appName)

res_sync_status = status["status"]["syncStatus"]
res_health_status = status["status"]["healthStatus"]
currentRetryCount = currentRetryCount + 1

task.setStatusLine("Sync status is %s, Health status is %s, Retry #%d" % (res_sync_status, res_health_status, currentRetryCount))
if (syncStatus and res_sync_status != syncStatus) or \
        (healthStatus and res_health_status != healthStatus):
    if currentRetryCount <= maxRetries:
        task.schedule("argocd/waitForStatus.py", retryWaitTime)
    else:
        raise Exception("Max Retry Count Reached.")
    task.schedule("argocd/waitForStatus.py", retryWaitTime)
else:
    syncResult = res_sync_status
    healthResult = res_health_status
    if "revision" in status:
        revision = status["revision"]
