#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#
import json
import logging

from xlrelease.HttpRequest import HttpRequest
from argocd.argocd_rest_client import RestClient

from com.xebialabs.xlrelease.lookup.api.internal import LookupResultElement

logger = logging.getLogger("ListRepos")
logger.addHandler(logging.StreamHandler(sys.stdout))

project_obj = RestClient(argo_server=argocdServer).getProject(project)

repo_list = []
repositories = project_obj["spec"]["sourceRepos"]

for repo in repositories:
    repo_list.append(LookupResultElement(repo, repo))

repo_objs = RestClient(argo_server=argocdServer).getRepoConnections()
repo_objs = repo_objs["items"]

for repo in repo_objs:
    if "project" in repo and repo["project"] == project:
        repo_list.append(LookupResultElement(repo["repo"], repo["repo"]))

result = repo_list