#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#
import json
from argocd.argocd_rest_client import RestClient

def validate_mandatory_field(field, error):
    if not field:
        raise ValueError(error)

validate_mandatory_field(argocdServer, "Missing value for ArgoCD Server")
validate_mandatory_field(appName, "Missing value for App Name")
validate_mandatory_field(resourceName, "Missing value for Resource Name")

client = RestClient(argo_server=argocdServer)
bearer_token = client.getBearerToken()
response = client.getAppDetails(appName, bearer_token)
resources = response["status"]["resources"]
resourceIndex = None
for i in range(len(resources)):
    rname = resources[i]['name']
    if resourceName == rname:
        resourceIndex = i

if resourceIndex == None:
    raise ValueError('Failed to get resource details %s' % response)

response = client.getResourceDetails(appName, resourceName, bearer_token)
liveManifest = json.loads(response["items"][0]["liveState"])
desiredManifest = json.loads(response["items"][0]["targetState"])
