#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#
import logging

from argocd.argocd_rest_client import RestClient

from com.xebialabs.xlrelease.lookup.api.internal import LookupResultElement

logger = logging.getLogger("ListCharts")
logger.addHandler(logging.StreamHandler(sys.stdout))

repo_objs = RestClient(argo_server=argocdServer).getRepoConnections()
repo_objs = repo_objs["items"]

version_list = []
for repo in repo_objs:
    if repo["repo"] == url:
        if repo["type"] == "helm":
            chart_versions = RestClient(argo_server=argocdServer).getChartVersions(url)
            chart_versions = chart_versions["items"]
            for chart in chart_versions:
                if chart["name"] == chartName:
                    for version in chart["versions"]:
                        version_list.append(LookupResultElement(version, version))
        else:
            revisions = RestClient(argo_server=argocdServer).getRevisions(url)
            branches = revisions["branches"]
            for branch in branches:
                version_list.append(LookupResultElement(branch, branch))
            if "tags" in revisions:
                tags = revisions["tags"]
                for tag in tags:
                    version_list.append(LookupResultElement("%s-tag" % tag, tag))

        result = version_list