#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

import yaml
import json

class kubeconfigParser:

    def __init__(self, content):
        self.content = content

    def get_current_context(self):
        config_content = str(self.content)

        kubeconfig = None
        try:
            kubeconfig = yaml.safe_load(config_content)
        except:
            try:
                kubeconfig = json.loads(config_content)
            except:
                raise ValueError('Failed to parse file. Check if file is a valid yaml or json file')

        current_context = kubeconfig["current-context"]
        context = self.get_context_info(kubeconfig, current_context)

        return context

    def get_context(self, context_name):

        if self.file_path.endswith(".yaml") :
            kubeconfig = yaml.safe_load(self.content)
        else:
            kubeconfig = json.loads(self.content)

        context = self.get_context_info(kubeconfig, context_name)

        return context

    def get_context_info(self, kubeconfig, context_name):
        # Get the current context info
        context = {}
        for entry in kubeconfig["contexts"]:
            if entry["name"] == context_name:
                context = entry["context"]
                break
        context["name"] = context_name

        # Get the cluster info for current context
        for entry in kubeconfig["clusters"]:
            if entry["name"] == context["cluster"]:
                cluster = entry["cluster"]
                if "certificate-authority" in cluster:
                    context["certificate-authority"] = cluster["certificate-authority"]
                if "api-version" in cluster:
                    context["api-version"] = cluster["api-version"]
                if "server" in cluster:
                    context["server"] = cluster["server"]
                break

        # Get the user info for current context
        user_name = context["user"]
        for entry in kubeconfig["users"]:
            if entry["name"] == user_name:
                user = entry["user"]
                if "token" in user:
                    context["token"] = user["token"]
                if "client-certificate" in user:
                    context["client-certificate"] = user["client-certificate"]
                elif "client-certificate-data" in user:
                    context["client-certificate"] = user["client-certificate-data"]
                if "client-key" in user:
                    context["client-key"] = user["client-key"]
                elif "client-key-data" in user:
                    context["client-key-data"] = user["client-key-data"]
                break

        return context
