#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#
from argocd.argocd_rest_client import RestClient
from com.xebialabs.xlrelease.status.service.script import AutoconfigResult
from com.xebialabs.deployit import ServerConfiguration
from com.xebialabs.xlrelease.script import EncryptionHelper

from argocd.status import ObjectView

# TODO: change docs url after autoconfiguration documentation is ready
DOC_URL = "https://docs.xebialabs.com/"

if not webhook:
    raise Exception("Webhook definition must be provided to script")

serverConf = ServerConfiguration.getInstance()
serverUrl = serverConf.getServerUrl()

webhookConf = {}
for entry in webhook.entrySet():
    webhookConf[entry.key] = entry.value
webhookConf = ObjectView(webhookConf)

authParam = ""
if webhookConf.eventSource.authentication().type.toString() == 'events.TokenAuthentication':
    authentication = webhookConf.eventSource.authentication()
    EncryptionHelper.decrypt(authentication)
    authParam = authentication.webhookToken()

endpointPath = serverUrl + "webhooks/" + webhookConf.eventSource.path()

yaml = RestClient.generateYaml(endpointPath, authParam)
data = AutoconfigResult("Successfully generated webhook ConfigMap. Copy the manifest below and apply it on cluster " +
                        "running the ArgoCD. See the documentation on below link to check details on how to enable " +
                        "Webhook events for your ArgoCD applications.", yaml, DOC_URL)
