#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

import com.xebialabs.xlrelease.plugin.argo.rollouts.RemoteScript as RemoteScript
import json

class KubeClient:

    def __init__(self, host, kubectl_path, kubectl_argo_path, flags=None):
        self.remote = RemoteScript(host)
        self.kubectl_path = kubectl_path
        self.kubectl_argo_path = kubectl_argo_path
        self.flags = flags

    def execute_rollout_command(self, command):
        print "Command to be executed is: %s %s %s" % (self.kubectl_argo_path, command, self.flags if self.flags else '')
        response = self.remote.executeScript("%s %s %s" % (self.kubectl_argo_path, command, self.flags if self.flags else ''))

        response_msg = None
        if response.rc > 0:
            error_msg = response.stderr
            raise RuntimeError("Command execution failed with error: %s" % error_msg)
        else:
            response_msg = response.stdout

        return response_msg

    def execute_command(self, command):
        print "Command to be executed is %s %s %s" % (self.kubectl_path, command, self.flags if self.flags else '')
        response = self.remote.executeScript("%s %s %s" % (self.kubectl_path, command, self.flags if self.flags else ''))

        response_msg = None
        if response.rc > 0:
            error_msg = response.stderr
            raise RuntimeError("Command execution failed with error: %s" % error_msg)
        else:
            response_msg = response.stdout

        return response_msg

    def get_rollout_status(self, rolloutName):
        command = "get rollout %s --output=json" % (rolloutName)
        response = self.execute_command(command)
        output = json.loads(response)
        health_status = output["status"]["phase"]

        return health_status

    def get_rollout_details(self, rolloutName, namespace):
        command = "%s get rollout %s -n %s --no-color %s" % (self.kubectl_argo_path, rolloutName, namespace, self.flags if self.flags else '')
        print "Command to be executed is %s" % command

        response = self.remote.executeScript2(command)
        values = None
        if response.rc > 0:
            error_msg = response.stderr
            raise RuntimeError("Command execution failed with error: %s" % error_msg)
        else:
            values = response.stdoutList

        return values



