#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from org.apache.http.client import ClientProtocolException

from argo.kube_client import KubeClient
from argo.commandParams import CommandHelper

global configuration

flags = []
commandline_params = None
flags = CommandHelper.commandParams(configuration, flags)

if flags:
    commandline_params = '%s' % (" ".join(flags) if flags else '')

try:
    command = "list rollouts"
    response = KubeClient(configuration._delegate.getProperty("host"), configuration.getProperty("kubectlPath"),
                          configuration.getProperty("kubectlArgoRolloutPath"), commandline_params)\
        .execute_rollout_command(command)
  
except ClientProtocolException:
    raise Exception("Check connection parameters")

