#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

import com.xebialabs.xlrelease.plugin.argocd.RemoteScript as RemoteScript
import json

class KubeClient:

    def __init__(self, host, kubectl_path, flags):
        self.remote = RemoteScript(host)
        self.kubectl_path = kubectl_path
        self.flags = flags

    def execute_rollout_command(self, command):
        if self.flags:
            command = command + " " + " ".join(self.flags)

        # print "Command to be executed is %s" % command
        response = self.remote.executeScript("kubectl argo rollouts %s" % command)

        response_msg = None
        if response.rc > 0:
            error_msg = response.stderr
            raise RuntimeError("Command execution failed with error: %s" % error_msg)
        else:
            response_msg = response.stdout

        return response_msg

    def execute_command(self, command):
        if self.flags:
            command = command + " " + " ".join(self.flags)

        # print "Command to be executed is %s" % command
        response = self.remote.executeScript(command)

        response_msg = None
        if response.rc > 0:
            error_msg = response.stderr
            raise RuntimeError("Command execution failed with error: %s" % error_msg)
        else:
            response_msg = response.stdout

        return response_msg

    def get_rollout_status(self, rolloutName):
        command = "kubectl get rollout %s --output=json" % rolloutName
        response = self.execute_command(command)
        output = json.loads(response)
        health_status = output["status"]["phase"]

        return health_status



