#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
import urllib2
import base64
import com.xebialabs.xlrelease.plugin.ansible.RemoteScript as RemoteScript

class APIClient:

    def __init__(self, host, ansible_path, cmd_params):
        self.remote = RemoteScript(host)
        self.script = "%s  %s " % (ansible_path, cmd_params if cmd_params else '')

    def execute_playbook(self,play_book):
        response = self.remote.executePlayBook(play_book,self.script)
        APIClient.print_logs(response)
        return response

    def execute_command(self,command):
        response = self.remote.executeScript(command)
        APIClient.print_logs(response)
        return response

    def execute_local_playbook(self,play_book_path):
        response = self.execute_command(self.script + " " + play_book_path)
        APIClient.print_logs(response)
        return response

    @staticmethod
    def download_file(url, username, password):
        request=urllib2.Request(url)
        if (username is not None) and (password is not None):
            base64string = base64.encodestring('%s:%s' % (username, password))[:-1]
            auth_header =  "Basic %s" % base64string
            request.add_header("Authorization", auth_header)

        return urllib2.urlopen(request).read()

    @staticmethod
    def validate_input(task):
        playbook = task.pythonScript.getProperty('playbook')
        playbook_path = task.pythonScript.getProperty('playbookPath')
        playbook_url = task.pythonScript.getProperty('playbookUrl')
        if not playbook  and not playbook_path and not playbook_url:
            raise Exception('No source for playbook (Inline | URL | LocalPlaybook) is provided.')
        elif ((playbook and playbook_path and playbook_url)
              or (playbook and playbook_path)
              or (playbook_path and playbook_url)
              or (playbook_url and playbook)):
            raise Exception('Please provide only one source for playbook.')

    @staticmethod
    def print_logs(response):
        if response.rc == 0:
            print "```"
            print response.stdout
            print "```"
        else:
            print "Exit code: "
            print response.rc
            print
            print "#### Output:"
            print "```"
            print response.stdout
            print "```"

            print "----"
            print "#### Error stream:"
            print "```"
            print response.stderr
            print "```"
            print

            sys.exit(response.rc)