#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
import json
from xlrelease.HttpRequest import HttpRequest
import time
import sys
from ansiblecontroller import AAPServer

ansible_instance = AAPServer(ansibletower,username,password,apiToken)
request = ansible_instance.create_request()
headers = ansible_instance.create_header()

retryCounter = {
    "currentPollingTrial": 0
}
api_url =  '/api/v2/workflow_jobs/%s/' % job_id
if max_retries:
    if retryCounter['currentPollingTrial'] < int(max_retries):
        # Define the URL for the Ansible Tower API endpoint to launch a job.
        response = request.get(api_url, contentType='application/json',headers=headers)
        if response.isSuccessful():
            result = json.loads(response.response)
            status=result['status']
            print("Job status is "+ status)
            if status not in ["running","pending","waiting"]:
              if stopOnFailure and not status == 'successful':
                raise Exception("Job status is "+ status)
              else:
                print("```")
                print(">>> Task completed after " + str(retryCounter['currentPollingTrial']+1) + " tries with status "+ status)
                print("```")
                print("\n")
                print("* [>>> Job %s Link](%s/#/jobs/workflow/%s/output) <<<" % (str(job_id), ansibletower['url'], str(job_id)))
                print("\n")
                result = "%s/#/jobs/workflow/%s/output" % (ansibletower['url'], str(job_id))
            else:
                retryCounter['currentPollingTrial']+=1
                task.schedule("ansiblecontroller/LaunchWorkflowWaitSchedule.py",int(wait_interval))
        else:
            raise Exception("Failed !. Server return [%s], with content [%s]" % (response.status, response.response))

    if retryCounter['currentPollingTrial'] == int(max_retries):
        # maximum number of tries reached, handle the error
        raise Exception("Error: maximum number of tries reached")


