#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xlrelease.HttpRequest import HttpRequest

class AAPServer:

    def __init__(self, ansibletower , username, password, api_token):
        if not ansibletower:
            raise Exception("No server provided.")
        self.ansibletower = ansibletower
        self.username = self.ansibletower['username']
        self.password = self.ansibletower['password']
        self.api_token = self.ansibletower['apiToken']
        if api_token:
            self.api_token = api_token
        if username and password:
            self.username = username
            self.password = password
        if (not self.username or not self.password) and not self.api_token:
            raise Exception("Either (username and password) or token must not be empty.")

    def create_request(self):
        params = self.ansibletower.copy()
        if self.api_token:
            params['authenticationMethod'] = None
            params.pop('username')
            params.pop('password')
        return HttpRequest(params)

    def create_header(self):
        if self.api_token:
            headers = {'Authorization': 'Bearer %s' % (self.api_token)}
            return headers
        else:
            return None
