#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import json
from ansiblecontroller import AAPServer
import time
import sys

if not ansibletower:
    print("Ansible Tower Server  must be provided")
    sys.exit(1)

if wait_interval is None:
    print("wait interval must be provided")
    sys.exit(1)

ansible_instance = AAPServer(ansibletower, username, password, apiToken)
request = ansible_instance.create_request()
headers = ansible_instance.create_header()

waiting_time = int(wait_interval)
job_id = None

if not isWorkflow:
    api_url = '/api/v2/job_templates/%s/launch/' % job_template_id
    body = {"extra_vars": extra_vars}
    response = request.post(api_url, body=json.dumps(body), contentType="application/json", headers=headers)
    result = json.loads(response.response)
    # Check the response status code to make sure the request was not successful.

    if not response.isSuccessful():
        print("Failed to run the job template. Server return [%s], with content [%s]" % (
        response.status, response.response))
        sys.exit(1)

    job_id = result["id"]

    print("```")
    print(">>> Job template launched with job id  " + str(job_id))
    print("```")
    print("\n")

    task.schedule("ansiblecontroller/LaunchWaitSchedule.py", 1)

else:
    api_url = '/api/v2/workflow_job_templates/%s/launch/' % job_template_id
    body = {"extra_vars": extra_vars}
    response = request.post(api_url, body=json.dumps(body), contentType="application/json", headers=headers)
    result = json.loads(response.response)
    # Check the response status code to make sure the request was not successful.

    if not response.isSuccessful():
        print("Failed to run the workflow job template. Server return [%s], with content [%s]" % (
        response.status, response.response))
        sys.exit(1)

    job_id = result["id"]

    print("```")
    print(">>> Workflow job template launched with job id  " + str(job_id))
    print("```")
    print("\n")

    task.schedule("ansiblecontroller/LaunchWorkflowWaitSchedule.py", 1)
