/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.apiclient.exceptions.ConnectionException;
import com.versionone.apiclient.exceptions.NotImplementedException;
import com.versionone.apiclient.interfaces.IAPIConnector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileAPIConnector
implements IAPIConnector {
    HashMap<String, String> _getData = new HashMap();
    HashMap<String, String[]> _postData = new HashMap();
    private static int REQUEST_INDEX = 0;
    private static int RESPONSE_INDEX = 1;
    private String _prefix = "";
    private String _lastPath;
    private String _lastData;

    public FileAPIConnector(String fileName, String prefix) {
        this._prefix = !prefix.endsWith("/") && !prefix.endsWith("\\") ? prefix + "/" : prefix;
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new File(fileName));
            doc.normalizeDocument();
            NodeList nodes = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node oneNode = nodes.item(i);
                if (oneNode.getNodeName().equals("Get")) {
                    this.processGetNode((Element)oneNode);
                    continue;
                }
                if (!oneNode.getNodeName().equals("Post")) continue;
                this.processPostNode((Element)oneNode);
            }
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Parser Configuration Error ", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Error ", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("SAX Error ", e);
        }
    }

    private void processPostNode(Element postNode) {
        String[] data = new String[]{"", ""};
        NodeList nodes = postNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node oneNode = nodes.item(i);
            if (oneNode.getNodeName().equals("Request")) {
                data[FileAPIConnector.REQUEST_INDEX] = oneNode.getTextContent().trim();
                continue;
            }
            if (!oneNode.getNodeName().equals("Response")) continue;
            data[FileAPIConnector.RESPONSE_INDEX] = oneNode.getTextContent().trim();
        }
        this._postData.put(postNode.getAttribute("path"), data);
    }

    private void processGetNode(Element oneNode) {
        this._getData.put(oneNode.getAttribute("path"), oneNode.getTextContent().trim());
    }

    @Override
    public Reader getData() throws ConnectionException {
        return this.getData("");
    }

    @Override
    public Reader getData(String path) throws ConnectionException {
        this._lastPath = this._prefix + path;
        if (this._getData.containsKey(this._lastPath)) {
            this._lastData = this._getData.get(this._lastPath);
            return new StringReader(this._lastData);
        }
        throw new ConnectionException("Cannot get data for " + path, 401);
    }

    @Override
    public InputStream getAttachment(String attachmentKey) throws ConnectionException {
        throw new NotImplementedException();
    }

    @Override
    public Reader sendData(String path, String data) throws ConnectionException {
        this._lastPath = this._prefix + path;
        if (this._postData.containsKey(this._lastPath)) {
            String[] postData = this._postData.get(this._lastPath);
            this.compareRequest(data, postData[REQUEST_INDEX]);
            this._lastData = postData[RESPONSE_INDEX];
            return new StringReader(this._lastData);
        }
        throw new ConnectionException("Cannot get data for " + path, 401);
    }

    private void compareRequest(String expected, String actual) throws ConnectionException {
        String trimmedActual;
        String trimmedExpected = expected.trim().replaceAll("\\s", "");
        if (!trimmedExpected.equals(trimmedActual = actual.trim().replaceAll("\\s", ""))) {
            throw new ConnectionException("Invalid Request", 400);
        }
    }

    public String getLastPath() {
        return this._lastPath;
    }

    public String getLastData() {
        return this._lastData;
    }

    @Override
    public OutputStream beginRequest(String path, String contentType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream endRequest(String path) {
        throw new UnsupportedOperationException();
    }
}

