/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.Oid;
import com.versionone.apiclient.Attribute;
import com.versionone.apiclient.MultiValueAttribute;
import com.versionone.apiclient.SingleValueAttribute;
import com.versionone.apiclient.exceptions.APIException;
import com.versionone.apiclient.exceptions.MetaException;
import com.versionone.apiclient.exceptions.OidException;
import com.versionone.apiclient.interfaces.IAssetType;
import com.versionone.apiclient.interfaces.IAttributeDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Asset {
    private Oid oid = Oid.Null;
    private Map<String, Attribute> attributes = new HashMap<String, Attribute>();
    private Map<String, Asset> newAssets = new HashMap<String, Asset>();
    private IAssetType assetType;
    private List<Asset> children = new ArrayList<Asset>();

    public IAssetType getAssetType() {
        return this.assetType;
    }

    public Oid getOid() {
        return this.oid;
    }

    public void setOid(Oid value) throws OidException {
        if (value.getAssetType() != this.assetType) {
            throw new OidException("Cannot change this asset's AssetType", value.getToken());
        }
        this.oid = value;
    }

    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    public Map<String, Asset> getNewAssets() {
        return this.newAssets;
    }

    public List<Asset> getChildren() {
        return this.children;
    }

    public Asset(Oid oid) {
        if (oid.isNull()) {
            throw new IllegalArgumentException("Cannot initialize Asset with NULL Oid");
        }
        this.oid = oid;
        this.assetType = oid.getAssetType();
    }

    public Asset(IAssetType assetType) {
        this.assetType = assetType;
    }

    public void setAttributeValue(IAttributeDefinition attributeDefinition, Object value) throws APIException {
        this.ensureAttribute(attributeDefinition).setValue(value);
    }

    public void forceAttributeValue(IAttributeDefinition attributeDefinition, Object value) throws APIException {
        this.ensureAttribute(attributeDefinition).forceValue(value);
    }

    public void addAttributeValue(IAttributeDefinition attributeDefinition, Object value) throws APIException {
        this.ensureAttribute(attributeDefinition).addValue(value);
    }

    public void removeAttributeValue(IAttributeDefinition attributeDefinition, Object value) throws APIException {
        this.ensureAttribute(attributeDefinition).removeValue(value);
    }

    public void clearAttributeCache(IAttributeDefinition attributeDefinition) {
        if (attributeDefinition == null) {
            this.attributes.clear();
        } else {
            this.attributes.remove(this.resolveAttributeDefinition(attributeDefinition).getToken());
        }
    }

    public Attribute getAttribute(IAttributeDefinition attributeDefinition) throws MetaException {
        return this.attributes.get(this.resolveAttributeDefinition(attributeDefinition).getToken());
    }

    private IAttributeDefinition resolveAttributeDefinition(IAttributeDefinition attributeDefinition) throws MetaException {
        if (this.getAssetType().isA(attributeDefinition.getAssetType())) {
            return this.getAssetType().getAttributeDefinition(attributeDefinition.getName());
        }
        return attributeDefinition;
    }

    public void acceptChanges() {
        for (Attribute attribute : this.attributes.values()) {
            attribute.acceptChanges();
        }
    }

    public void rejectChanges() {
        for (Attribute attribute : this.attributes.values()) {
            attribute.rejectChanges();
        }
    }

    public boolean hasChanged() {
        for (Attribute attribute : this.attributes.values()) {
            if (!attribute.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public void loadAttributeValue(IAttributeDefinition attributeDefinition, Object value) throws APIException {
        this.ensureAttribute(attributeDefinition).loadValue(value);
    }

    public Attribute ensureAttribute(IAttributeDefinition attributeDefinition) throws APIException {
        try {
            attributeDefinition = this.resolveAttributeDefinition(attributeDefinition);
        }
        catch (MetaException e) {
            throw new APIException("Cannot resolve Attribute", attributeDefinition.getToken(), e);
        }
        Attribute attribute = this.attributes.get(attributeDefinition.getToken());
        if (attribute == null) {
            attribute = attributeDefinition.isMultiValue() ? new MultiValueAttribute(attributeDefinition, this) : new SingleValueAttribute(attributeDefinition, this);
            this.attributes.put(attributeDefinition.getToken(), attribute);
        }
        return attribute;
    }
}

