/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.apiclient.exceptions.MetaException;
import com.versionone.apiclient.interfaces.IAssetType;
import com.versionone.apiclient.interfaces.IAttributeDefinition;
import com.versionone.apiclient.interfaces.IMetaModel;
import com.versionone.apiclient.interfaces.IOperation;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class Operation
implements IOperation {
    private IMetaModel Meta;
    private String _name;
    private String _assettypetoken;
    private IAssetType _assettype;
    private String _validatortoken;
    private IAttributeDefinition _validator;

    public Operation(IMetaModel meta, Element element) {
        this.Meta = meta;
        String of = element.getAttribute("of");
        String[] ofs = of.split("/");
        this._assettypetoken = ofs[ofs.length - 1];
        this._name = element.getAttribute("name");
        NodeList validators = element.getElementsByTagName("Validator");
        if (validators != null && validators.getLength() > 0) {
            this._validatortoken = ((Element)validators.item(0)).getAttribute("tokenref");
        }
    }

    public Operation(IMetaModel meta, String assettypetoken, Element element) {
        this(meta, element);
        this._assettypetoken = assettypetoken;
    }

    @Override
    public IAssetType getAssetType() throws MetaException {
        if (this._assettype == null && this._assettypetoken != null) {
            this._assettype = this.Meta.getAssetType(this._assettypetoken);
        }
        return this._assettype;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getToken() {
        return this._assettypetoken + "." + this._name;
    }

    @Override
    public IAttributeDefinition getValidatorAttribute() throws MetaException {
        if (this._validator == null && this._validatortoken != null) {
            this._validator = this.Meta.getAttributeDefinition(this._validatortoken);
        }
        return this._validator;
    }
}

