#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys, traceback, datetime
from versionone.VersionOneClient import VersionOneClient
from versionone import add_plan_record

try:
    data = {}
    v1Client = VersionOneClient.create_v1Client( versionOneServer )
    v1Client.updateAssetStatus( ticket, status , "Story")
    whereClause="Number='%s'" % ticket
    results = v1Client.getStories( whereClause )
    asset = results['Assets'][0]
    data['Name'] = asset['Attributes']['Name']['value']
    data['Number'] = asset['Attributes']['Number']['value']
    data['Status'] = asset['Attributes']['Status.Name']['value']
    print("data=%s" % data)
except :
    traceback.print_exc(file=sys.stdout)
    sys.exit(1)
    # End try

_ticket = ticket
_title = asset['Attributes']['Name']['value']
_ticketType = "Story"
_ticketUrl = versionOneServer['url']
_updatedDate = datetime.datetime.now()
_updatedBy = versionOneServer['username']

add_plan_record(task_reporting_api=taskReportingApi, task=task,
                versionOneServer=versionOneServer, ticket=_ticket,
                title=_title, ticketType=_ticketType, ticketUrl=_ticketUrl, status="PASSED",
                updatedDate=_updatedDate, updatedBy=_updatedBy)

