#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys, traceback, itertools
from versionone.VersionOneClient import VersionOneClient

# convert int to string and list to comma separated values to avoid unicode characters
def getAttributeValues(attributeValues):
   value = str(attributeValues) if type(attributeValues) is int else attributeValues
   return ",".join(value) if type(value) is list else value

try:
   v1Client = VersionOneClient.create_v1Client( versionOneServer )
   results = v1Client.getStories( whereClause )
   assets = results['Assets']
   assetFields = ['Status','Owners','Priority','Team',
                  'Risk','RequestedBy','Estimate','Description']
   assetValues = ['Status.Name','Owners.Name','Priority.Name','Team.Name',
                  'Risk.Name','RequestedBy','Estimate','Description']

   data = {}
   if getAdditionalData:
      for asset in assets:
         assetNumber = asset['Attributes']['Number']['value']
         data[assetNumber] = {'Asset Name : %s' % getAttributeValues(asset['Attributes']['Name']['value']) }
         print("Story : %s" % assetNumber )
         print("==========")
         for assetField,assetValue in itertools.izip_longest(assetFields,assetValues):
            if asset['Attributes'][assetValue]['value'] is not None:
               attributeValue = getAttributeValues(asset['Attributes'][assetValue]['value'])
               data[assetNumber].update({"%s : %s" % (assetField,attributeValue)})
               print("%s : %s" % (assetField,attributeValue))
         if asset['Attributes']['Super']['value'] is not None:
            data[assetNumber].update({"Portfolio : %s" % getAttributeValues(asset['Attributes']['Super']['value']['idref'])})
            print("Portfolio : %s" % asset['Attributes']['Super']['value']['idref'])
      # End for
   else:
      for asset in assets:
         assetNumber = asset['Attributes']['Number']['value']
         print("Story : %s" % assetNumber )
         print("==========")
         assetName   = asset['Attributes']['Name']['value']
         assetNumber = asset['Attributes']['Number']['value']
         assetStatus = asset['Attributes']['Status.Name']['value']
         print("%s " % (assetName))
         print("%s " % (assetNumber))
         print("%s " % (assetStatus))
         data[assetNumber] = "%s | %s " % (assetName, assetStatus )
      # End for

except :
   traceback.print_exc(file=sys.stdout)
   sys.exit(1)
   # End try