#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

# Name, Description,Status.Name, Owners.Name , href, id, AssetType

import com.xhaus.jyson.JysonCodec as json
from versionone.VersionOneClient import VersionOneClient

v1Client = VersionOneClient.create_v1Client(agilityServer)
response = v1Client.getAssetsForTile(assetType, query)
if response.getStatus() == 200:
    results = json.loads(response.getResponse())
    assets_data = results["Assets"]
    data = {}

    for asset in assets_data:
        asset_id = asset["id"]
        attributes = asset["Attributes"]
        owners = attributes.get("Owners.Name", {}).get("value", [])
        owners_string = ", ".join(owners) if isinstance(owners, list) else owners
        status_value = attributes.get("Status.Name", {}).get("value", "")
        formatted_status = status_value.title() if isinstance(status_value, str) else status_value
        link = agilityServer['url'].rstrip("/") + "/assetdetail.v1?oid="+asset_id
        data[asset_id] = {
            "name": attributes.get("Name", {}).get("value"),
            "status": attributes.get("Status.Name", {}).get("value"),
            "owners": owners_string,
            "link": link,
            "id": asset_id
        }
else:
    error = "Exception occurred: " + str(response.getStatus()) + " : " + str(response.getResponse())
    data = {'error': error}