/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.Oid;
import com.versionone.apiclient.AttributeSelection;
import com.versionone.apiclient.Paging;
import com.versionone.apiclient.filters.IFilterTerm;
import com.versionone.apiclient.interfaces.IAssetType;
import com.versionone.apiclient.interfaces.IAttributeDefinition;
import com.versionone.apiclient.services.OrderBy;
import com.versionone.apiclient.services.QueryFind;
import com.versionone.apiclient.services.QueryVariable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Query {
    public static final Date MIN_DATE = new Date(0L);
    private IAssetType assetType = null;
    private AttributeSelection selection = new AttributeSelection();
    private boolean isHistorical;
    private Oid oid;
    private IAttributeDefinition parentRelation;
    private IFilterTerm filter = null;
    private OrderBy orderBy = new OrderBy();
    private Paging paging = new Paging();
    private Date asOf = MIN_DATE;
    private QueryFind find = null;
    private List<QueryVariable> variables = new ArrayList<QueryVariable>();
    private boolean needTotal;

    public Query(IAssetType assettype) {
        this(assettype, false);
    }

    public Query(IAssetType assettype, IAttributeDefinition parentrelation) {
        this(assettype, false, parentrelation);
    }

    public Query(IAssetType assettype, boolean historical) {
        this(assettype, historical, null);
    }

    public Query(IAssetType assettype, boolean historical, IAttributeDefinition parentrelation) {
        this.assetType = assettype;
        this.isHistorical = historical;
        this.oid = Oid.Null;
        this.parentRelation = parentrelation;
        if (this.parentRelation != null) {
            if (this.parentRelation.getAttributeType() != IAttributeDefinition.AttributeType.Relation) {
                throw new RuntimeException("Parent Relation must be a Relation Attribute Type");
            }
            if (this.parentRelation.isMultiValue()) {
                throw new RuntimeException("Parent Relation cannot be multi-value");
            }
        }
    }

    public Query(Oid oid, boolean historical) {
        if (oid.isNull()) {
            throw new RuntimeException("Invalid Query OID Parameter");
        }
        if (oid.hasMoment() && historical) {
            throw new UnsupportedOperationException("Historical Query with Momented OID not supported");
        }
        this.isHistorical = historical;
        this.assetType = oid.getAssetType();
        this.oid = oid;
    }

    public Query(Oid oid) {
        this(oid, false);
    }

    public boolean isHistorical() {
        return this.isHistorical;
    }

    public IAssetType getAssetType() {
        return this.assetType;
    }

    public Oid getOid() {
        return this.oid;
    }

    protected IAttributeDefinition getParentRelation() {
        return this.parentRelation;
    }

    public AttributeSelection getSelection() {
        return this.selection;
    }

    public void setSelection(AttributeSelection value) {
        if (null != value) {
            this.selection = value;
        }
    }

    public void setFilter(IFilterTerm value) {
        if (null != value) {
            this.filter = value;
        }
    }

    public IFilterTerm getFilter() {
        return this.filter;
    }

    public void setOrderBy(OrderBy value) {
        if (null != value) {
            this.orderBy = value;
        }
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setPaging(Paging value) {
        if (null != value) {
            this.paging = value;
        }
    }

    public Paging getPaging() {
        return this.paging;
    }

    public void setAsOf(Date value) {
        this.asOf = value;
    }

    public Date getAsOf() {
        return this.asOf;
    }

    public QueryFind getFind() {
        return this.find;
    }

    public void setFind(QueryFind value) {
        this.find = value;
    }

    public List<QueryVariable> getVariables() {
        return this.variables;
    }

    public void setNeedTotal(boolean value) {
        this.needTotal = value;
    }

    public boolean getNeedTotal() {
        return this.needTotal;
    }
}

