/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.apiclient.AssetType;
import com.versionone.apiclient.AttributeDefinition;
import com.versionone.apiclient.Operation;
import com.versionone.apiclient.V1Connector;
import com.versionone.apiclient.XMLHandler;
import com.versionone.apiclient.exceptions.ConnectionException;
import com.versionone.apiclient.exceptions.MetaException;
import com.versionone.apiclient.exceptions.V1Exception;
import com.versionone.apiclient.interfaces.IAPIConnector;
import com.versionone.apiclient.interfaces.IAssetType;
import com.versionone.apiclient.interfaces.IAttributeDefinition;
import com.versionone.apiclient.interfaces.IMetaModel;
import com.versionone.apiclient.interfaces.IOperation;
import com.versionone.apiclient.services.TextBuilder;
import com.versionone.utils.Version;
import java.io.IOException;
import java.io.Reader;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MetaModel
implements IMetaModel {
    private Map<String, Object> _map = new HashMap<String, Object>();
    private IAPIConnector _connector;
    private Version _version;
    private String _versionString = null;
    private V1Connector _v1Connector;

    public MetaModel(IAPIConnector connector) {
        this(connector, false);
    }

    public MetaModel(IAPIConnector connector, boolean hookup) {
        this._connector = connector;
        if (hookup) {
            this.hookup();
        }
    }

    public MetaModel(V1Connector v1Connector) {
        this(v1Connector, false);
    }

    public MetaModel(V1Connector v1Connector, boolean hookup) {
        this._v1Connector = v1Connector;
        if (hookup) {
            this.hookup();
        }
    }

    @Override
    public IAssetType getAssetType(String token) throws MetaException {
        try {
            return this.findAssetType(token);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new MetaException("Unknown AssetType", token, ex);
        }
    }

    public Version getVersion() throws MetaException {
        if (this._version == null) {
            if (this._versionString == null) {
                this.getAssetType("BaseAsset");
            }
            if (this._versionString != null) {
                this._version = new Version(this._versionString);
            }
        }
        return this._version;
    }

    @Override
    public IAttributeDefinition getAttributeDefinition(String token) throws MetaException {
        try {
            return this.findAttributeDefinition(token);
        }
        catch (Exception ex) {
            throw new MetaException("Unknown AttributeDefinition", token, ex);
        }
    }

    @Override
    public IOperation getOperation(String token) throws MetaException {
        try {
            return this.findOperation(token);
        }
        catch (Exception ex) {
            throw new MetaException("Unknown Operation", token, ex);
        }
    }

    private IAssetType findAssetType(String token) throws Exception {
        if (this._map.containsKey(token)) {
            return (IAssetType)this._map.get(token);
        }
        return this.hookupAssetType(token);
    }

    private void saveAssetType(IAssetType assettype) {
        this._map.put(assettype.getToken(), assettype);
    }

    private IAttributeDefinition findAttributeDefinition(String token) throws Exception {
        StringBuffer prefix = new StringBuffer();
        StringBuffer suffix = new StringBuffer();
        TextBuilder.splitPrefix(token, '.', prefix, suffix);
        this.findAssetType(prefix.toString());
        if (this._map.containsKey(token)) {
            return (IAttributeDefinition)this._map.get(token);
        }
        return this.hookupAttributeDefinition(prefix.toString(), suffix.toString());
    }

    private void saveAttributeDefinition(IAttributeDefinition attribdef) {
        this._map.put(attribdef.getToken(), attribdef);
    }

    private IOperation findOperation(String token) throws Exception {
        StringBuffer prefix = new StringBuffer();
        StringBuffer suffix = new StringBuffer();
        TextBuilder.splitPrefix(token, '.', prefix, suffix);
        this.findAssetType(prefix.toString());
        if (this._map.containsKey(token)) {
            return (IOperation)this._map.get(token);
        }
        return this.hookupOperation(prefix.toString(), suffix.toString());
    }

    private void saveOperation(IOperation op) {
        this._map.put(op.getToken(), op);
    }

    private IAssetType hookupAssetType(String token) throws Exception {
        Document doc = null;
        doc = this.createDocument(token);
        String dc = doc.toString();
        AssetType assetType = new AssetType(this, doc.getDocumentElement(), this._map);
        this.saveAssetType(assetType);
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList attribnodes = (NodeList)xpath.evaluate("AttributeDefinition", doc.getDocumentElement(), XPathConstants.NODESET);
        for (int attrIndex = 0; attrIndex < attribnodes.getLength(); ++attrIndex) {
            this.saveAttributeDefinition(new AttributeDefinition(this, (Element)attribnodes.item(attrIndex)));
        }
        NodeList opnodes = (NodeList)xpath.evaluate("Operation", doc.getDocumentElement(), XPathConstants.NODESET);
        for (int opIndex = 0; opIndex < opnodes.getLength(); ++opIndex) {
            this.saveOperation(new Operation(this, assetType.getToken(), (Element)opnodes.item(opIndex)));
        }
        return assetType;
    }

    private IAttributeDefinition hookupAttributeDefinition(String assettypetoken, String name) throws Exception {
        Document doc = this.createDocument(assettypetoken + "/" + name);
        AttributeDefinition attribdef = new AttributeDefinition(this, doc.getDocumentElement());
        this.saveAttributeDefinition(attribdef);
        return attribdef;
    }

    private IOperation hookupOperation(String assettypetoken, String name) throws V1Exception {
        Document doc = this.createDocument(assettypetoken + "/" + name);
        Operation op = new Operation(this, doc.getDocumentElement());
        this.saveOperation(op);
        return op;
    }

    private void hookup() {
        try {
            Document doc = this.createDocument("");
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList assetnodes = (NodeList)xpath.evaluate("//AssetType", doc.getDocumentElement(), XPathConstants.NODESET);
            for (int assetIndex = 0; assetIndex < assetnodes.getLength(); ++assetIndex) {
                Element element = (Element)assetnodes.item(assetIndex);
                this.saveAssetType(new AssetType(this, element, this._map));
                NodeList attribnodes = element.getElementsByTagName("AttributeDefinition");
                for (int attribIndex = 0; attribIndex < attribnodes.getLength(); ++attribIndex) {
                    Element attribelement = (Element)attribnodes.item(attribIndex);
                    this.saveAttributeDefinition(new AttributeDefinition(this, attribelement));
                }
                NodeList opnodes = element.getElementsByTagName("Operation");
                for (int opIndex = 0; opIndex < opnodes.getLength(); ++opIndex) {
                    Element opelement = (Element)opnodes.item(opIndex);
                    this.saveOperation(new Operation(this, element.getAttribute("token"), opelement));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Document createDocument(String token) throws V1Exception {
        Reader reader = null;
        Document rc = null;
        try {
            if (this._connector != null) {
                reader = this._connector.getData(token);
            } else {
                this._v1Connector.useMetaAPI();
                reader = this._v1Connector.getData(URLEncoder.encode(token));
            }
            rc = XMLHandler.buildDocument(reader, token);
            this._versionString = rc.getDocumentElement().getAttribute("version").toString();
        }
        catch (ConnectionException e) {
            e.printStackTrace();
            throw new MetaException("Error creating Document", token, e);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return rc;
    }
}

