/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.List;

public final class V1Util {
    private static String CR_XML = "&#10;";
    private static String CR_SYSTEM = "\r";

    private V1Util() {
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public static void copyStream(Reader input, Writer output) throws IOException {
        V1Util.copyStream(input, output, 4096);
    }

    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        V1Util.copyStream(input, output, 4096);
    }

    public static void copyStream(Reader input, Writer output, int buffersize) throws IOException, IllegalArgumentException {
        int n;
        if (buffersize < 1) {
            throw new IllegalArgumentException("buffersize must be greater than 0");
        }
        char[] buffer = new char[buffersize];
        while ((n = input.read(buffer)) >= 0) {
            output.write(buffer, 0, n);
        }
    }

    public static void copyStream(InputStream input, OutputStream output, int buffersize) throws IOException, IllegalArgumentException {
        int n;
        if (buffersize < 1) {
            throw new IllegalArgumentException("buffersize must be greater than 0");
        }
        byte[] buffer = new byte[buffersize];
        while ((n = input.read(buffer)) >= 0) {
            output.write(buffer, 0, n);
        }
    }

    public static <T> T[] convertListToArray(List<?> oids, Class<T> clazz) {
        Object[] resultArray = (Object[])Array.newInstance(clazz, oids.size());
        return oids.toArray(resultArray);
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static String convertSystemCrToXmlCr(String string) {
        return string.replace(CR_SYSTEM, CR_XML);
    }

    public static String convertXmlCrToSystemCr(String string) {
        return string.replace(CR_XML, CR_SYSTEM);
    }
}

