/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.apiclient.exceptions.APIException;
import com.versionone.apiclient.exceptions.ConnectionException;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLHandler {
    public static Document buildDocument(Reader reader, String url) throws APIException, ConnectionException {
        try {
            Document doc;
            DocumentBuilder builder = XMLHandler.createDocumentBuilder();
            Document document = doc = builder.parse(new InputSource(reader));
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new APIException("Parser Configuration Error ", url, e);
        }
        catch (IOException e) {
            throw new ConnectionException("IO Error: " + url, e);
        }
        catch (SAXException e) {
            throw new APIException("SAX Error ", url, e);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder;
    }
}

