/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.Oid;
import com.versionone.apiclient.Asset;
import com.versionone.apiclient.Attribute;
import com.versionone.apiclient.Query;
import com.versionone.apiclient.exceptions.APIException;
import com.versionone.apiclient.exceptions.ConnectionException;
import com.versionone.apiclient.exceptions.MetaException;
import com.versionone.apiclient.exceptions.OidException;
import com.versionone.apiclient.filters.AndFilterTerm;
import com.versionone.apiclient.filters.FilterTerm;
import com.versionone.apiclient.interfaces.IAssetType;
import com.versionone.apiclient.interfaces.IAttributeDefinition;
import com.versionone.apiclient.interfaces.IMetaModel;
import com.versionone.apiclient.interfaces.IServices;
import com.versionone.apiclient.services.QueryResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequiredFieldValidator {
    private final Map<IAssetType, List<IAttributeDefinition>> requiredFields = new HashMap<IAssetType, List<IAttributeDefinition>>();
    private final IMetaModel metaModel;
    private final IServices services;

    public RequiredFieldValidator(IMetaModel metaModel, IServices services) {
        this.metaModel = metaModel;
        this.services = services;
    }

    public boolean validate(Asset asset, IAttributeDefinition attributeDefinition) throws APIException, ConnectionException, OidException {
        boolean result;
        this.getRequiredFields(asset.getAssetType());
        asset.ensureAttribute(attributeDefinition);
        Attribute attribute = asset.getAttribute(attributeDefinition);
        boolean bl = result = attribute != null && !this.isMultiValueAndUnfilled(attribute) && !this.isSingleValueAndUnfilled(attribute);
        if (!result) {
            result = !attribute.hasChanged() && !this.isAttributeUnfilledOnServer(asset, attributeDefinition);
        }
        return result;
    }

    public List<IAttributeDefinition> validate(Asset asset) throws APIException, ConnectionException, OidException {
        this.getRequiredFields(asset.getAssetType());
        ArrayList<IAttributeDefinition> results = new ArrayList<IAttributeDefinition>();
        List<IAttributeDefinition> requiredAttributes = this.requiredFields.get(asset.getAssetType());
        for (IAttributeDefinition attributeDefinition : requiredAttributes) {
            asset.ensureAttribute(attributeDefinition);
            Attribute attribute = asset.getAttribute(attributeDefinition);
            if (attribute != null && this.validate(asset, attributeDefinition)) continue;
            results.add(attributeDefinition);
        }
        return results;
    }

    public Map<Asset, List<IAttributeDefinition>> validate(Asset[] assets) throws APIException, ConnectionException, OidException {
        HashMap<Asset, List<IAttributeDefinition>> results = new HashMap<Asset, List<IAttributeDefinition>>();
        for (Asset asset : assets) {
            results.put(asset, this.validate(asset));
        }
        return results;
    }

    public boolean isRequired(IAssetType assetType, String attributeName) throws ConnectionException, APIException, OidException, MetaException {
        return this.isRequired(assetType.getAttributeDefinition(attributeName));
    }

    public boolean isRequired(IAttributeDefinition definition) throws ConnectionException, APIException, OidException, MetaException {
        this.getRequiredFields(definition.getAssetType());
        return this.isRequiredField(definition.getAssetType(), definition.getName());
    }

    private void getRequiredFields(IAssetType assetType) throws ConnectionException, APIException, OidException {
        if (!this.requiredFields.containsKey(assetType)) {
            List<IAttributeDefinition> requiredFieldsForType = this.loadRequiredFields(assetType);
            this.requiredFields.put(assetType, requiredFieldsForType);
        }
    }

    private List<IAttributeDefinition> loadRequiredFields(IAssetType assetType) throws ConnectionException, APIException, OidException {
        ArrayList<IAttributeDefinition> requiredFieldsForType = new ArrayList<IAttributeDefinition>();
        IAssetType attributeDefinitionAssetType = this.metaModel.getAssetType("AttributeDefinition");
        IAttributeDefinition nameAttributeDef = attributeDefinitionAssetType.getAttributeDefinition("Name");
        IAttributeDefinition assetNameAttributeDef = attributeDefinitionAssetType.getAttributeDefinition("Asset.AssetTypesMeAndDown.Name");
        Query query = new Query(attributeDefinitionAssetType);
        query.getSelection().add(nameAttributeDef);
        FilterTerm assetTypeTerm = new FilterTerm(assetNameAttributeDef);
        assetTypeTerm.equal(assetType.getToken());
        query.setFilter(new AndFilterTerm(assetTypeTerm));
        QueryResult result = this.services.retrieve(query);
        for (Asset asset : result.getAssets()) {
            String name;
            Attribute attr = asset.getAttribute(nameAttributeDef);
            if (attr == null || !this.isRequiredField(assetType, name = (String)attr.getValue())) continue;
            IAttributeDefinition definition = assetType.getAttributeDefinition(name);
            requiredFieldsForType.add(definition);
        }
        return requiredFieldsForType;
    }

    private boolean isRequiredField(IAssetType assetType, String name) {
        IAttributeDefinition def = assetType.getAttributeDefinition(name);
        return def.isRequired() && !def.isReadOnly();
    }

    private boolean isSingleValueAndUnfilled(Attribute attribute) throws APIException {
        return !attribute.getDefinition().isMultiValue() && (attribute.getValue() instanceof Oid && ((Oid)attribute.getValue()).isNull() || attribute.getValue() == null);
    }

    private boolean isMultiValueAndUnfilled(Attribute attribute) {
        return attribute.getDefinition().isMultiValue() && attribute.getValues().length < 1;
    }

    private boolean isAttributeUnfilledOnServer(Asset asset, IAttributeDefinition attributeDefinition) {
        if (asset.getOid() == Oid.Null) {
            return true;
        }
        Query query = new Query(asset.getOid());
        query.getSelection().add(attributeDefinition);
        QueryResult result = null;
        try {
            result = this.services.retrieve(query);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result != null) {
            Attribute attr = result.getAssets()[0].getAttribute(attributeDefinition);
            try {
                return this.isSingleValueAndUnfilled(attr) && this.isMultiValueAndUnfilled(attr);
            }
            catch (APIException aPIException) {
                // empty catch block
            }
        }
        return true;
    }
}

